/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import DE.siemens.ad.udf.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidVersionMgr
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SortedMap<Long, Long> map = new TreeMap<Long, Long>();
    public static final int GUID_COMPARE_LOWER = -1;
    public static final int GUID_COMPARE_EQUAL = 0;
    public static final int GUID_COMPARE_HIGHER = 1;
    public static final int GUID_COMPARE_NO_INTER = 2;

    public GuidVersionMgr() {
    }

    public GuidVersionMgr(long guid) {
        this.map.put(GuidVersionMgr.getLongValueOfVer("1.0.0"), guid);
    }

    public GuidVersionMgr(long guid, String version) {
        this.map.put(GuidVersionMgr.getLongValueOfVer(version), guid);
    }

    public boolean containsGuid(long guid) {
        return this.map.containsValue(guid);
    }

    public String getVersion() {
        if (this.map.isEmpty()) {
            return "";
        }
        return GuidVersionMgr.getVersionFromLong(this.map.lastKey());
    }

    public String getVersion(long guid) {
        for (Map.Entry<Long, Long> entry : this.map.entrySet()) {
            if (entry.getValue() != guid) continue;
            return GuidVersionMgr.getVersionFromLong(entry.getKey());
        }
        return null;
    }

    public long getGuid() {
        if (this.map.size() == 0) {
            return 0L;
        }
        return (Long)this.map.get(this.map.lastKey());
    }

    public void addGuid(String version, long guid) {
        this.map.put(GuidVersionMgr.getLongValueOfVer(version), guid);
    }

    public List<GuidVerPair> getGuidMap() {
        ArrayList<GuidVerPair> list = new ArrayList<GuidVerPair>();
        for (Map.Entry<Long, Long> entry : this.map.entrySet()) {
            list.add(new GuidVerPair(entry.getValue(), GuidVersionMgr.getVersionFromLong(entry.getKey())));
        }
        return list;
    }

    public int compareTo(GuidVersionMgr anotherMgr) {
        if (!this.getGuidMap().get(0).equals(anotherMgr.getGuidMap().get(0))) {
            return 2;
        }
        if (this.getGuidMap().size() == anotherMgr.getGuidMap().size()) {
            return 0;
        }
        if (this.getGuidMap().size() > anotherMgr.getGuidMap().size()) {
            return 1;
        }
        return -1;
    }

    public boolean isSpecified() {
        return this.map.size() > 0;
    }

    public static long getLongValueOfVer(String ver) {
        String[] vers = ver.split("\\.");
        long high = Integer.parseInt(vers[0]);
        long mid = Integer.parseInt(vers[1]);
        long low = Integer.parseInt(vers[2]);
        return (high << 32) + (mid << 16) + low;
    }

    public static String getVersionFromLong(long value) {
        return "" + (value >> 32 & 0xFFFFL) + "." + (value >> 16 & 0xFFFFL) + "." + (value & 0xFFFFL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GuidVerPair
    extends Pair<Long, String> {
        public GuidVerPair(Long guid, String version) {
            super(guid, version);
        }

        @Override
        public int hashCode() {
            return ((Long)this.first).hashCode();
        }
    }
}

